#version 430

layout (location = 0) in vec3 fragViewPos;
layout (location = 1) in smooth vec3 fragNormal;
layout (location = 2) in vec2 fragTexCoords;
layout (location = 3) in vec4 fragPosLightSpace;
layout (location = 4) flat in uvec3 fragInstanceID; 

layout (location = 0) out vec3 gAlbedoSpec;
layout (location = 1) out vec4 gViewPosition;
layout (location = 2) out vec3 gNormal;
layout (location = 3) out vec4 gPhysical;
layout (location = 4) out vec2 gInstanceID;
layout (location = 5) out vec4 gShadowVisibility;


layout (binding = 1) uniform sampler2D rgbTexture;
layout (binding = 2) uniform sampler2D physicalTexture;

uniform mat4 view;

void main(){
 
	float alphaValue = texture(physicalTexture, fragTexCoords.xy).a;
	float playerID = float(fragInstanceID.z);

	if(alphaValue == 0.0 && alphaValue == 1.0){
		discard;
	}

	vec3 ShadowCoord = fragPosLightSpace.xyz / fragPosLightSpace.w;

	gShadowVisibility.xyz = ShadowCoord.xyz;
	gShadowVisibility.w = gl_FragCoord.z;


	gAlbedoSpec = vec4(texture(rgbTexture, fragTexCoords.xy)).xyz;
	gPhysical.xyzw = vec4(texture(physicalTexture, fragTexCoords.xy));

	 if(texture(physicalTexture, fragTexCoords.xy).y > 0.1){

	 if (playerID == 1.0){
		gAlbedoSpec.x = gAlbedoSpec.x;
		gAlbedoSpec.y = 0.0;
		gAlbedoSpec.z = 0.0;
	 }
	 if (playerID == 2.0){
		gAlbedoSpec.y = gAlbedoSpec.y;
		gAlbedoSpec.x = 0.0;
		gAlbedoSpec.z = 0.0;
	 }
	 if (playerID == 3.0){
		gAlbedoSpec.z = gAlbedoSpec.z;
		gAlbedoSpec.x = 0.0;
		gAlbedoSpec.y = 0.0;
	 }
	 if (playerID == 4.0){
		gAlbedoSpec.y = gAlbedoSpec.y;
		gAlbedoSpec.x = gAlbedoSpec.x;
		gAlbedoSpec.z = 0.0;
	 }
	 }


	gViewPosition.xyz = fragViewPos.xyz;
	gViewPosition.w = gl_FragCoord.z;

	gNormal = normalize(fragNormal.xyz);

	gInstanceID = vec2(fragInstanceID.xy);

	
}